/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validator.LoginValidator.java
 * Desprition : This Validator class is responsible for checking and validating the 
 * Customer Login .
 * 
 */
package Validators;
import nz.co.k.tms.ldap.*;

import DataClasses.*;
/**
 * @author student
 *
 * This class is being used for authenticating the username and password
 * with the LDAP server.
 * 
 */
public class LoginValidator {

	private String message;

	/**
	 * This method is being used for getting the error message if the validation
	 * is unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * This method is being used for setting the error message.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used for validating the username and password.
	 * @param userData The user who is to be authenticated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(User_Data userData) {

		User_Data customerdata = userData;
		String password, userName;

		password = customerdata.getPassword();
		userName = customerdata.getUserName();

		if (password == null || userName == null) {
			message = "Either password or username is blank.";
			return false;
		} else {
			try {
				UserDetail ud =
					LdapHelper.authentiacteUser(
						userData.getUserName(),
						userData.getPassword());
			} catch (Exception e) {
				message = "Either password is wrong or user does not exist.";
				System.out.println("Unsuccessful login:");
				System.out.println("String : " + e.toString());
				return false;
			}
			return true;
		}

	}
}
